function Initialize()
	if not OWNER:HasAttribute( "paused" ) then
		OWNER:SetBool( "paused", false )
	end

	if not OWNER:HasAttribute( "time" ) then
		OWNER:SetFloat( "time", 0 )
	end
	
	if not OWNER:HasAttribute( "updateAutomatically" ) then
		OWNER:SetBool( "updateAutomatically", false )
	end
end

function Update()
	if OWNER:GetBool( "updateAutomatically" ) and not OWNER:GetBool( "paused" ) then
		OWNER:SetFloat( "time", OWNER:GetFloat( "time" ) + ELAPSED_SECONDS )
	end
	
	local t = OWNER:GetFloat( "time" );
	local hours = math.floor( t / 3600 )
	local mins  = math.floor( t / 60 ) % 60
	local secs  = math.floor( t ) % 60
	
	local text = ""
	if hours > 0 then
		text = hours .. ":"
		if mins < 10 then
			text = text .. "0"
		end
	end
	
	if mins > 0 then
		text = text .. mins .. ":"
		if secs < 10 then
			text = text .. "0"
		end
	end
	
	text = text .. secs
	
	game.ConvertToVisualText( OWNER:GetVisual() ):SetText( text )
end