function Initialize()
	if not OWNER:HasAttribute( "selectedItem" ) then
		OWNER:SetInt( "selectedItem", 0 )
	end
	
	if OWNER:HasAttribute( "numItems" ) then
		local anglePerItem = 2 * math.pi / OWNER:GetInt( "numItems" )
		OWNER:GetNode2D():SetAngle( game.Radian( anglePerItem * OWNER:GetInt( "selectedItem") + anglePerItem / 2 ) )
	else
		OWNER:GetNode2D():SetAngle( game.Radian( 0 ) )
	end
end

function Update()
	local slowDownFactor = 100
	OWNER:GetNode2D():SetAngle( game.Radian( OWNER:GetNode2D():GetAngle():ToFloat() - 
		                                     GAME:GetInputSystem():GetMouseDeltas().m_x / slowDownFactor ) )
end

function HandleEvent( event )
	if OWNER:HasAttribute( "numItems" ) and event:GetID() == "Event_MouseButtonPressed" then
		print( OWNER:GetID() )
		print( OWNER:IsEnabled() )
		local selection = math.floor( OWNER:GetNode2D():GetAngle():ToFloat() / ( 2 * math.pi / OWNER:GetInt( "numItems" ) ) )
		selection = selection % OWNER:GetInt( "numItems" )
		rotator.SendEvent_SelectionWheelSelection( OWNER:GetID(), selection )
	end
end