function Initialize()
	print( "LevelControl - initialize" )
	
	--[[ not possible in script because of swig<->lua troubles with std::tr1::shared_ptr returned by CreateEntity
	     it seems as if this shared_ptr instance is never destroyed and therefore the object never will be deleted
	
	local pos = game.NodeData()
	pos:SetPosition( GAME:GetGameState():GetEntityManager():GetEntity( "checkpoint0" ):GetNode():GetPosition() )
	
	GAME:GetGameState():GetEntityFactory():CreateEntity( "Ball", "ball", pos )
	GAME:GetGameState():GetEntityManager():GetEntity( "ball" ):Enable()
	
	game.RenderSystem_GetInstance():GetDefaultViewport():GetCameraPointer():SetPosition( pos.m_position )
	GAME:GetGameState():GetEntityFactory():CreateEntity( "Camera", "camera", pos )
	GAME:GetGameState():GetEntityManager():GetEntity( "camera" ):Enable()
	
	]]
	
	OWNER:SetString( "currentCheckpoint", "checkpoint0" )
end

function Update()
	if OWNER:HasAttribute( "restart" ) and OWNER:GetBool( "restart" ) then
		OWNER:SetString( "currentCheckpoint", "Checkpoint0" )
		GAME:GetGameState():GetEntityManager():GetEntity( "timer" ):SetFloat( "time", 0 )
		ResetBallToCheckpoint()
		OWNER:SetBool( "restart", false )
	end
end

function HandleEvent( event )
	if event:GetID() == "Event_EntityCollision" then
		if event:GetEntityID1() == "ball" then
			HandleCollision( event:GetEntityID2() )
		elseif event:GetEntityID2() == "ball" then
			HandleCollision( event:GetEntityID1() )
		end
	elseif event:GetID() == "Event_MouseButtonPressed" then
		if event:GetPressedButton() == game.M_RIGHT then
			SetMenuEnabled( not GAME:GetGameState():GetEntityManager():GetEntity( "ingameMenu" ):IsEnabled() )
		end
	elseif event:GetID() == "Event_KeyboardButtonPressed" then
		if event:GetButton() == game.K_ESCAPE then
			SetMenuEnabled( not GAME:GetGameState():GetEntityManager():GetEntity( "ingameMenu" ):IsEnabled() )
		end
	end
end

function SetMenuEnabled( enable )
	if GAME:GetGameState():GetEntityManager():GetEntity( "highscore" ):IsEnabled() then
		return
	end
	
	GAME:GetGameState():GetPhysicsManager():SetPaused( enable )
	GAME:GetGameState():GetEntityManager():GetEntity( "timer" ):SetBool( "paused", enable )
	if enable then
		GAME:GetGameState():GetEntityManager():GetEntity( "ingameMenu" ):Enable()
	else
		GAME:GetGameState():GetEntityManager():GetEntity( "ingameMenu" ):Disable()
	end
end

function HandleCollision( entity )
	if entity:find( "Checkpoint" ) then
		OWNER:SetString( "currentCheckpoint", entity )
		local node = GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "currentCheckpoint" ) ):GetNode()
		GAME:GetGameState():GetEntityManager():GetEntity( "currentCheckpoint" ):GetNode():Set( node:GetPosition(), node:GetOrientation(), node:GetScale() )
		GAME:GetGameState():GetEntityManager():GetEntity( "currentCheckpoint" ):GetNode():Translate( game.Vector( 0, 0, -0.01 ) )
	elseif entity:find( "Goal" ) then
		if OWNER:GetFloat( "timeToBeat" ) == -1 or 
		   OWNER:GetFloat( "timeToBeat" ) > GAME:GetGameState():GetEntityManager():GetEntity( "timer" ):GetFloat( "time" ) then
		   
		   GAME:GetGameState():GetPhysicsManager():SetPaused( true )
		   GAME:GetGameState():GetEntityManager():GetEntity( "timer" ):SetBool( "paused", true )
		   GAME:GetGameState():GetEntityManager():GetEntity( "highscore" ):Enable()
		else
			game.EventManager_GetInstance():SendEvent( game.Event_SwitchGameState_Create( "GameStateMenu" ) )
		end
	elseif entity:find( "DeathZone" ) then
		ResetBallToCheckpoint()
	end
end

function ResetBallToCheckpoint()
	local pos = GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "currentCheckpoint" ) ):GetNode():GetPosition()
	local ball = GAME:GetGameState():GetEntityManager():GetEntity( "ball" )
	ball:GetNode():SetPosition( pos )
	ball:GetNode():Translate( game.Vector( 0, 0, -0.1 ) )
	ball:GetPhysicsBody():SetLinearVelocity( game.Vector( 0, 0 ) )
end